/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.init.ModEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatrolSpawner.class})
public class PatrolSpawnerMixin {
    boolean isBiomeSpecificIllagerSpawned = false;

    @ModifyVariable(method={"spawnPillager"}, ordinal=0, at=@At(value="LOAD"))
    private PatrollingMonster modifyPatrolEntity(PatrollingMonster patrolEntity, ServerLevel world, BlockPos pos, Random random, boolean captain) {
        Holder registryEntry = world.m_204166_(pos);
        Biome.BiomeCategory category = Biome.m_204183_((Holder)registryEntry);
        if (category != Biome.BiomeCategory.TAIGA || this.isBiomeSpecificIllagerSpawned) {
            return patrolEntity;
        }
        this.isBiomeSpecificIllagerSpawned = true;
        Biome.Precipitation precipitation = ((Biome)registryEntry.m_203334_()).m_47530_();
        patrolEntity = precipitation == Biome.Precipitation.SNOW ? (PatrollingMonster)((EntityType)ModEntity.ICEOLOGER.get()).m_20615_((Level)world) : (PatrollingMonster)EntityType.f_20459_.m_20615_((Level)world);
        return patrolEntity;
    }

    @Inject(method={"spawn"}, at={@At(value="RETURN")})
    private void resetBiomeSpecificIllagerSpawnFlag(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals, CallbackInfoReturnable<Integer> callbackInfo) {
        Integer spawnerPatrolMembersCount = (Integer)callbackInfo.getReturnValue();
        if (spawnerPatrolMembersCount > 0) {
            this.isBiomeSpecificIllagerSpawned = false;
        }
    }
}

